/*
 * Decompiled with CFR 0.152.
 */
package com.bosschongsheng.client;

import com.bosschongsheng.client.BossRespawnConfigScreen;
import com.bosschongsheng.config.BossRespawnConfigClient;
import com.bosschongsheng.network.PacketAddBossRule;
import com.bosschongsheng.network.PacketRequestConfig;
import com.bosschongsheng.network.XiangcaoNet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class RulePickerScreen
extends Screen {
    private final BossRespawnConfigScreen parent;
    private final boolean isEdit;
    private final String editStructureId;
    private List<String> structureIds = new ArrayList<String>();
    private List<ItemEntry> allItems = new ArrayList<ItemEntry>();
    private List<EntityEntry> allEntities = new ArrayList<EntityEntry>();
    private EditBox searchStructure;
    private EditBox searchItem;
    private EditBox searchEntity;
    private List<String> filteredStructures = new ArrayList<String>();
    private List<ItemEntry> filteredItems = new ArrayList<ItemEntry>();
    private List<EntityEntry> filteredEntities = new ArrayList<EntityEntry>();
    private String selectedStructureId;
    private String selectedItemId;
    private String selectedEntityId;
    private int scrollStructure;
    private int scrollItem;
    private int scrollEntity;
    private static final int PAD = 10;
    private static final int TITLE_H = 20;
    private static final int SEARCH_H = 20;
    private static final int ROW_H = 18;
    private static final int LIST_H = 180;
    private static final int VISIBLE_ROWS = 10;
    private static final int FOOTER_H = 32;
    private static final int MIN_COL_W = 200;
    private static final int PANEL_BG = -14013643;
    private static final int PANEL_BORDER = -12763318;
    private static final int ROW_HOVER = -13223862;
    private static final int SELECTED_BG = -13809107;
    private int panelLeft;
    private int panelTop;
    private int panelW;
    private int panelH;
    private boolean layoutHorizontal;

    public RulePickerScreen(BossRespawnConfigScreen parent, String preStructureId, String preItemId, String preEntityId, boolean isEdit) {
        super((Component)Component.m_237115_((String)(isEdit ? "gui.bosschongsheng.config.edit_rule" : "gui.bosschongsheng.config.add_rule")));
        this.parent = parent;
        this.isEdit = isEdit;
        this.editStructureId = preStructureId;
        this.selectedStructureId = preStructureId != null ? preStructureId : "";
        this.selectedItemId = preItemId != null ? preItemId : "";
        this.selectedEntityId = preEntityId != null ? preEntityId : "";
        this.structureIds = new ArrayList<String>(BossRespawnConfigClient.getStructureIds());
        this.filteredStructures.addAll(this.structureIds);
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ResourceLocation id;
            if (item == Items.f_41852_ || (id = ForgeRegistries.ITEMS.getKey((Object)item)) == null) continue;
            this.allItems.add(new ItemEntry(id.toString(), new ItemStack((ItemLike)item)));
        }
        this.allItems.sort(Comparator.comparing(e -> e.stack.m_41786_().getString()));
        this.filteredItems.addAll(this.allItems);
        for (ResourceLocation id : ForgeRegistries.ENTITY_TYPES.getKeys()) {
            this.allEntities.add(new EntityEntry(id.toString()));
        }
        this.allEntities.sort(Comparator.comparing(e -> RulePickerScreen.entityName(e.id)));
        this.filteredEntities.addAll(this.allEntities);
    }

    private static String structureName(String id) {
        return Component.m_237115_((String)("structure." + id.replace(":", "."))).getString();
    }

    private static String entityName(String id) {
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)id));
        if (type == null) {
            return id;
        }
        return Component.m_237115_((String)type.m_20675_()).getString();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.layoutHorizontal = this.f_96543_ >= 720;
        int colW = this.layoutHorizontal ? Math.min(200, (this.f_96543_ - 80) / 3) : this.f_96543_ - 20;
        this.panelW = this.layoutHorizontal ? colW * 3 + 40 : colW + 20;
        int colH = 250;
        this.panelH = this.layoutHorizontal ? colH + 32 + 10 : colH * 3 + 32 + 20;
        this.panelLeft = (this.f_96543_ - this.panelW) / 2;
        this.panelTop = (this.f_96544_ - this.panelH) / 2;
        int y0 = this.panelTop + 20 + 10;
        int searchW = this.layoutHorizontal ? colW : this.panelW - 20;
        this.searchStructure = new EditBox(this.f_96547_, this.panelLeft + 10, y0, searchW, 20, (Component)Component.m_237113_((String)"s"));
        this.searchStructure.m_257771_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.search_structure_hint"));
        this.searchStructure.m_94151_(s -> this.refreshStructureFilter());
        this.m_142416_((GuiEventListener)this.searchStructure);
        int y1 = this.layoutHorizontal ? y0 : this.panelTop + 250 + 10 + 20 + 10;
        this.searchItem = new EditBox(this.f_96547_, this.panelLeft + (this.layoutHorizontal ? 10 + colW + 10 : 10), y1, searchW, 20, (Component)Component.m_237113_((String)"i"));
        this.searchItem.m_257771_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.search_item_hint"));
        this.searchItem.m_94151_(s -> this.refreshItemFilter());
        this.m_142416_((GuiEventListener)this.searchItem);
        int y2 = this.layoutHorizontal ? y0 : this.panelTop + 500 + 10 + 20 + 10;
        this.searchEntity = new EditBox(this.f_96547_, this.panelLeft + (this.layoutHorizontal ? 10 + (colW + 10) * 2 : 10), y2, searchW, 20, (Component)Component.m_237113_((String)"e"));
        this.searchEntity.m_257771_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.search_entity_hint"));
        this.searchEntity.m_94151_(s -> this.refreshEntityFilter());
        this.m_142416_((GuiEventListener)this.searchEntity);
        int btnY = this.panelTop + this.panelH - 32 - 10;
        int btnW = 70;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.bosschongsheng.config.confirm"), b -> this.confirm()).m_252987_(this.panelLeft + 10, btnY, btnW, 22).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.f_96541_.m_91152_((Screen)this.parent)).m_252987_(this.panelLeft + 10 + btnW + 10, btnY, btnW, 22).m_253136_());
    }

    private void refreshStructureFilter() {
        String q = this.searchStructure != null ? this.searchStructure.m_94155_().toLowerCase(Locale.ROOT).trim() : "";
        this.filteredStructures = q.isEmpty() ? new ArrayList<String>(this.structureIds) : this.structureIds.stream().filter(id -> id.toLowerCase(Locale.ROOT).contains(q) || RulePickerScreen.structureName(id).toLowerCase(Locale.ROOT).contains(q)).collect(Collectors.toList());
        this.scrollStructure = Math.min(this.scrollStructure, Math.max(0, this.filteredStructures.size() - 10));
    }

    private void refreshItemFilter() {
        String q = this.searchItem != null ? this.searchItem.m_94155_().toLowerCase(Locale.ROOT).trim() : "";
        this.filteredItems = q.isEmpty() ? new ArrayList<ItemEntry>(this.allItems) : this.allItems.stream().filter(e -> e.id.toLowerCase(Locale.ROOT).contains(q) || e.stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains(q)).collect(Collectors.toList());
        this.scrollItem = Math.min(this.scrollItem, Math.max(0, this.filteredItems.size() - 10));
    }

    private void refreshEntityFilter() {
        String q = this.searchEntity != null ? this.searchEntity.m_94155_().toLowerCase(Locale.ROOT).trim() : "";
        this.filteredEntities = q.isEmpty() ? new ArrayList<EntityEntry>(this.allEntities) : this.allEntities.stream().filter(e -> e.id.toLowerCase(Locale.ROOT).contains(q) || RulePickerScreen.entityName(e.id).toLowerCase(Locale.ROOT).contains(q)).collect(Collectors.toList());
        this.scrollEntity = Math.min(this.scrollEntity, Math.max(0, this.filteredEntities.size() - 10));
    }

    private void confirm() {
        if (this.selectedStructureId == null || this.selectedStructureId.isEmpty() || this.selectedItemId == null || this.selectedItemId.isEmpty() || this.selectedEntityId == null || this.selectedEntityId.isEmpty()) {
            return;
        }
        XiangcaoNet.CHANNEL.sendToServer((Object)new PacketAddBossRule(this.selectedStructureId, this.selectedItemId, this.selectedEntityId));
        XiangcaoNet.CHANNEL.sendToServer((Object)new PacketRequestConfig());
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public void m_86600_() {
        super.m_86600_();
        this.refreshStructureFilter();
        this.refreshItemFilter();
        this.refreshEntityFilter();
    }

    private int colW() {
        return this.layoutHorizontal ? Math.min(200, (this.panelW - 40) / 3) : this.panelW - 20;
    }

    private int listTop(int col) {
        int base = this.panelTop + 20 + 10 + 20 + 10;
        if (this.layoutHorizontal) {
            return base;
        }
        return base + col * 250;
    }

    private int colLeft(int col) {
        if (this.layoutHorizontal) {
            return this.panelLeft + 10 + col * (this.colW() + 10);
        }
        return this.panelLeft + 10;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (int c = 0; c < 3; ++c) {
            int left = this.colLeft(c);
            int top = this.listTop(c);
            if (!(mouseX >= (double)left) || !(mouseX < (double)(left + this.colW())) || !(mouseY >= (double)top) || !(mouseY < (double)(top + 180))) continue;
            if (c == 0) {
                int max = Math.max(0, this.filteredStructures.size() - 10);
                this.scrollStructure = (int)Math.max(0.0, Math.min((double)max, (double)this.scrollStructure - delta));
            } else if (c == 1) {
                int max = Math.max(0, this.filteredItems.size() - 10);
                this.scrollItem = (int)Math.max(0.0, Math.min((double)max, (double)this.scrollItem - delta));
            } else {
                int max = Math.max(0, this.filteredEntities.size() - 10);
                this.scrollEntity = (int)Math.max(0.0, Math.min((double)max, (double)this.scrollEntity - delta));
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        int left0 = this.colLeft(0);
        int top0 = this.listTop(0);
        int left1 = this.colLeft(1);
        int top1 = this.listTop(1);
        int left2 = this.colLeft(2);
        int top2 = this.listTop(2);
        for (int i = 0; i < 10; ++i) {
            int rowY;
            if (i < this.filteredStructures.size() && mouseY >= (double)(rowY = top0 + i * 18) && mouseY < (double)(rowY + 18) && mouseX >= (double)left0 && mouseX < (double)(left0 + this.colW())) {
                this.selectedStructureId = this.filteredStructures.get(this.scrollStructure + i);
                return true;
            }
            if (i < this.filteredItems.size() && mouseY >= (double)(rowY = top1 + i * 18) && mouseY < (double)(rowY + 18) && mouseX >= (double)left1 && mouseX < (double)(left1 + this.colW())) {
                this.selectedItemId = this.filteredItems.get((int)(this.scrollItem + i)).id;
                return true;
            }
            if (i >= this.filteredEntities.size() || !(mouseY >= (double)(rowY = top2 + i * 18)) || !(mouseY < (double)(rowY + 18)) || !(mouseX >= (double)left2) || !(mouseX < (double)(left2 + this.colW()))) continue;
            this.selectedEntityId = this.filteredEntities.get((int)(this.scrollEntity + i)).id;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int idx;
        int idx2;
        int idx3;
        this.m_280273_(graphics);
        graphics.m_280509_(this.panelLeft, this.panelTop, this.panelLeft + this.panelW, this.panelTop + this.panelH, -14013643);
        graphics.m_280509_(this.panelLeft, this.panelTop, this.panelLeft + this.panelW, this.panelTop + 1, -12763318);
        graphics.m_280509_(this.panelLeft, this.panelTop + this.panelH - 1, this.panelLeft + this.panelW, this.panelTop + this.panelH, -12763318);
        graphics.m_280509_(this.panelLeft, this.panelTop, this.panelLeft + 1, this.panelTop + this.panelH, -12763318);
        graphics.m_280509_(this.panelLeft + this.panelW - 1, this.panelTop, this.panelLeft + this.panelW, this.panelTop + this.panelH, -12763318);
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.panelLeft + 10, this.panelTop + 6, 0xF0F0F0, false);
        String structLabel = Component.m_237115_((String)"gui.bosschongsheng.config.structure").getString();
        String itemLabel = Component.m_237115_((String)"gui.bosschongsheng.config.trigger_item").getString();
        String entityLabel = Component.m_237115_((String)"gui.bosschongsheng.config.entity").getString();
        int labelY0 = this.panelTop + 20 - 2;
        int labelY1 = this.layoutHorizontal ? labelY0 : this.listTop(1) - 20 - 10 - 10;
        int labelY2 = this.layoutHorizontal ? labelY0 : this.listTop(2) - 20 - 10 - 10;
        graphics.m_280056_(this.f_96547_, structLabel, this.colLeft(0), labelY0, 0xB0B0B0, false);
        graphics.m_280056_(this.f_96547_, itemLabel, this.colLeft(1), this.layoutHorizontal ? labelY0 : labelY1, 0xB0B0B0, false);
        graphics.m_280056_(this.f_96547_, entityLabel, this.colLeft(2), this.layoutHorizontal ? labelY0 : labelY2, 0xB0B0B0, false);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int left0 = this.colLeft(0);
        int top0 = this.listTop(0);
        for (int i = 0; i < 10 && (idx3 = this.scrollStructure + i) < this.filteredStructures.size(); ++i) {
            String id = this.filteredStructures.get(idx3);
            int rowY = top0 + i * 18;
            boolean sel = id.equals(this.selectedStructureId);
            if (sel) {
                graphics.m_280509_(left0, rowY, left0 + this.colW(), rowY + 18, -13809107);
            } else if (mouseX >= left0 && mouseX < left0 + this.colW() && mouseY >= rowY && mouseY < rowY + 18) {
                graphics.m_280509_(left0, rowY, left0 + this.colW(), rowY + 18, -13223862);
            }
            Object name = RulePickerScreen.structureName(id);
            if (this.f_96547_.m_92895_((String)name) > this.colW() - 6) {
                name = this.f_96547_.m_92834_((String)name, this.colW() - 10) + "..";
            }
            graphics.m_280056_(this.f_96547_, (String)name, left0 + 4, rowY + 5, 0xE0E0E0, false);
        }
        int left1 = this.colLeft(1);
        int top1 = this.listTop(1);
        for (int i = 0; i < 10 && (idx2 = this.scrollItem + i) < this.filteredItems.size(); ++i) {
            ItemEntry e = this.filteredItems.get(idx2);
            int rowY = top1 + i * 18;
            boolean sel = e.id.equals(this.selectedItemId);
            if (sel) {
                graphics.m_280509_(left1, rowY, left1 + this.colW(), rowY + 18, -13809107);
            } else if (mouseX >= left1 && mouseX < left1 + this.colW() && mouseY >= rowY && mouseY < rowY + 18) {
                graphics.m_280509_(left1, rowY, left1 + this.colW(), rowY + 18, -13223862);
            }
            graphics.m_280480_(e.stack, left1 + 2, rowY + 1);
            Object name = e.stack.m_41786_().getString();
            if (this.f_96547_.m_92895_((String)name) > this.colW() - 24) {
                name = this.f_96547_.m_92834_((String)name, this.colW() - 28) + "..";
            }
            graphics.m_280056_(this.f_96547_, (String)name, left1 + 20, rowY + 5, 0xE0E0E0, false);
        }
        int left2 = this.colLeft(2);
        int top2 = this.listTop(2);
        for (int i = 0; i < 10 && (idx = this.scrollEntity + i) < this.filteredEntities.size(); ++i) {
            EntityEntry e = this.filteredEntities.get(idx);
            int rowY = top2 + i * 18;
            boolean sel = e.id.equals(this.selectedEntityId);
            if (sel) {
                graphics.m_280509_(left2, rowY, left2 + this.colW(), rowY + 18, -13809107);
            } else if (mouseX >= left2 && mouseX < left2 + this.colW() && mouseY >= rowY && mouseY < rowY + 18) {
                graphics.m_280509_(left2, rowY, left2 + this.colW(), rowY + 18, -13223862);
            }
            Object name = RulePickerScreen.entityName(e.id);
            if (this.f_96547_.m_92895_((String)name) > this.colW() - 6) {
                name = this.f_96547_.m_92834_((String)name, this.colW() - 10) + "..";
            }
            graphics.m_280056_(this.f_96547_, (String)name, left2 + 4, rowY + 5, 0xE0E0E0, false);
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private static class ItemEntry {
        final String id;
        final ItemStack stack;

        ItemEntry(String id, ItemStack stack) {
            this.id = id;
            this.stack = stack;
        }
    }

    private static class EntityEntry {
        final String id;

        EntityEntry(String id) {
            this.id = id;
        }
    }
}

